/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.comp.GetPasswordPanel;
import DE.siemens.ad.logo.dialog.comp.NetworkReusablePanels;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import javax.swing.JComponent;

public class SlaveModeConfigurePanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private NetworkReusablePanels.SelectIPAddressPanel fSelectPanel;
    private NetworkReusablePanels.SetSlaveModePanel fSlavePanel;

    public SlaveModeConfigurePanel() {
        this.setLayout(new GridBagLayout());
        this.setName(Language.getString("extra.slaveSetting", "Configure Normal/Slave Mode..."));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 2, 4);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.getSelectPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)this.getSlavePanel(), constraints);
    }

    private NetworkReusablePanels.SelectIPAddressPanel getSelectPanel() {
        if (this.fSelectPanel == null) {
            this.fSelectPanel = new NetworkReusablePanels.SelectIPAddressPanel();
            this.fSelectPanel.setTitle(Language.getString("extra.ipConfigure.destinationIP", "Destination IP Address"));
        }
        return this.fSelectPanel;
    }

    private NetworkReusablePanels.SetSlaveModePanel getSlavePanel() {
        if (this.fSlavePanel == null) {
            this.fSlavePanel = new NetworkReusablePanels.SetSlaveModePanel();
            this.fSlavePanel.setTitle(Language.getString("dialog.parameter.maxMin.mode", "Mode"));
        }
        return this.fSlavePanel;
    }

    public boolean checkFieldContents() {
        if (!this.getSelectPanel().checkFieldContents()) {
            return false;
        }
        return this.fSlavePanel.checkFieldContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFieldContents() {
        DataTransfer dt = null;
        try {
            dt = TcpSocketDataTransfer.openConnection(this.getSelectPanel().getIPAddress(), true, false);
            if (!dt.getHardware().supports("supportNetwork")) {
                new LogoError(null, "extra.ipConfigure.doNotSupportNetworkFunction", "The connected BM does not support network function.", 2, 0).display();
            }
            if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                throw new ExceptionAlreadyHandledException();
            }
            this.checkPassword(dt);
            int slaveByte = this.getSlavePanel().isSlaveMode() ? 1 : 0;
            dt.writeByte(this.getModeAddressInEEprom(dt.getHardware()), slaveByte);
            if (this.getSlavePanel().isSlaveMode()) {
                int ip = IPV4Utils.getInstance().formatToInt(this.getSlavePanel().getIPAddress());
                dt.writeDoubleWord(this.getMasterIPAddressInEEprom(dt.getHardware()), ip);
                Log.println(Language.getString("extra.transfer.configureSlaveModeSuccessfully", "Slave mode and master IP are set successfully."));
            } else {
                dt.writeDoubleWord(this.getMasterIPAddressInEEprom(dt.getHardware()), -1);
                Log.println(Language.getString("extra.transfer.configureNormalModeSuccessfully", "Normal mode is successfully configured."));
            }
            dt.sendCommand(38);
        }
        catch (Exception exception) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
    }

    private int getModeAddressInEEprom(Hardware hw) {
        if (hw instanceof Logo7) {
            return 4880;
        }
        throw new IllegalArgumentException();
    }

    private int getMasterIPAddressInEEprom(Hardware hw) {
        if (hw instanceof Logo7) {
            return 4896;
        }
        throw new IllegalArgumentException();
    }

    private int getIPPasswordInEEprom(Hardware hw) {
        if (hw instanceof Logo7) {
            return 4930;
        }
        throw new IllegalArgumentException();
    }

    private void checkPassword(DataTransfer dt) throws ProgramException, ExceptionAlreadyHandledException {
        int locked = 255;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            try {
                locked = dt.readByte(this.getIPPasswordInEEprom(dt.getHardware()));
                if (locked > 0) {
                    String s = this.uploadIPPassword(dt);
                    GetPasswordPanel pwPanel = new GetPasswordPanel();
                    SplittedDlg dlg = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), pwPanel, 11);
                    dlg.show();
                    if (dlg.getControlPanel().getResult() == 2) {
                        throw new ExceptionAlreadyHandledException();
                    }
                    if (!pwPanel.getPassword().equals(s)) {
                        new LogoError(Language.getString("error.wrongPassword", "Wrong password")).display();
                        throw new ExceptionAlreadyHandledException();
                    }
                }
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
    }

    private String uploadIPPassword(DataTransfer dt) throws TransmissionFailedException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16);
        int[] intArray = dt.readByteArray(this.getIPPasswordInEEprom(dt.getHardware()), 10);
        for (int i = 0; i < intArray.length && intArray[i] != 0; ++i) {
            buffer.write(intArray[i]);
        }
        String password = buffer.toString();
        return password;
    }
}

